# -----------------------------------------------------------------------
# --
# -- Copyright (c) 2011 VINAS
# -- All rights reserved.
# --
# -- This sample FieldView Python script is not supported
# --                                     by VINAS and VINAS provides
# -- no warranties or assurances about its fitness or merchantability.
# -- It is provided at no cost and is for demonstration purposes only.
# --
# -----------------------------------------------------------------------

import sys
print("Python version is ", sys.version)

from fv import *


print ("---- Python Sample PY119 ----")


## define data input table 
data_input_table  =  {
	'data_format' :   "unstructured",
	'input_parameters' :   {
			'name' :   './rect_duct_001.uns',
			'options' :   {
				'input_mode' :   "replace",
				#'transient' :   "on"
				'transient' :   "off"
		                  },
	                   }
                    }


## call function to read dataset
read_dataset(data_input_table)

## define boundary tableA
boundary_tableA = {
	'dataset' : 1,
	'geometric_color' : 4,
	'visibility' : "on",
	#'scalar_func' : "temperature",
	'display_type' : "smooth_shading",
}


## create boundary surface as handle name 'boundA'
boundA=create_boundary(boundary_tableA)


## detect all boundary types
Btype=get_all_boundary_types(1, boundA)


## list up all boundary types
print(" ----- key list -----")
for key in Btype.keys():
	print (key)
print("")

print(" ----- value list -----")
for value in Btype.values():
	print (value)
print("")


print(" ----- item list -----")
for key, value in Btype.items():
	print (key,  ":",  value)
print("")


## insert 'types' key into 'boundary_tableA'
boundary_tableA ['types'] = Btype


## modify 'boundA' handle
modify(boundA, boundary_tableA)

