# coding: utf-8
# -----------------------------------------------------------------------
# --
# -- Copyright (c) 2011 VINAS
# -- All rights reserved.
# --
# -- This sample FieldView Python script is not supported
# --                                     by VINAS and VINAS provides
# -- no warranties or assurances about its fitness or merchantability.
# -- It is provided at no cost and is for demonstration purposes only.
# --
# -----------------------------------------------------------------------

import sys
print("Python version is ", sys.version)

from fv import *


print ("---- Python Sample PY122 ----")

## define data input table 
data_input_table  =  {
	'data_format' :   "unstructured",
	'input_parameters' :   {
			'name' :   './rect_duct_001.uns',
			'options' :   {
				'input_mode' :   "replace",
				'transient' :   "on"
				#'transient' :   "off"
		                  },
	                   }
                    }

## call function to read dataset
read_dataset(data_input_table)

## initial point setting
seeds={ 'x' : {1 : 0.0,  2: 0.0, },
		'y' : {1 : 0.0125, 2:  0.0127},
		'z' : {1 : 0.0125, 2:  0.0115},
}


## seedint input table
seeding_input_table = {
		'seed_coord' : 'XYZ',
		'mode' : 'add',
		'seeds' : seeds
		}

## define streamline table
streamline_table = {
	'vector_func' : 'velocity',
	'scalar_func' : 'temperature',
	'dataset' : 1,
	'visibility' : 'on',
	'seeding' : seeding_input_table,
	'display_seeds' : 'on',
	'calculation_parameters' : {
		'direction' :'forward',
		'step' : 5,
		'time_limit' :20,
		'release_interval' :10,
		'duration' : 3},
	}


## create streamline
rake_handle=create_streamline(streamline_table)

