# coding: utf-8
# -----------------------------------------------------------------------
# --
# -- Copyright (c) 2011 VINAS
# -- All rights reserved.
# --
# -- This sample FieldView Python script is not supported
# --                                     by VINAS and VINAS provides
# -- no warranties or assurances about its fitness or merchantability.
# -- It is provided at no cost and is for demonstration purposes only.
# --
# -----------------------------------------------------------------------

import sys
print("Python version is ", sys.version)

from fv import *

print ("---- Python Sample PY124 ----")

## define plot3d option dictionary
plot3d_options = {
	'format' : "binary",
	'input_mode' : 'replace',
	'coords' : '3d',
	'multi_grid' : 'off',
	'iblanks' : 'off',
	'transient' : 'off',
	}

## define data input table 
data_input_table  =  {
	'data_format' :   "plot3d",
	'server_config' : '',
	'input_parameters' : {
		'xyz_file' : {
			'name' : "./bluntfinx.bin",
			'grid_point_increment' : 1,
			'options' : plot3d_options,
			},
		'q_file' : {
			'name' : "./bluntfinq.bin",
			'options' : plot3d_options,
			},
		},
	}

## call function to read dataset
read_dataset(data_input_table)

## define computational surface dictionary
comp_table = {
	'dataset' : 1,
	'grid' : 1,
	'axis' : "K",
	'K_inc' : 1,
	'display_type' : "smooth_shading",
	'scalar_func' : "y-momentum (Q3)",
}

## create computational surface
c_handle=create_comp(comp_table)

