!
!     _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
!     _/_/_/                                                        _/_/_/
!     _/_/_/    vf[^ PLOT3D f[^ւ̕ϊ                _/_/_/
!     _/_/_/                                    vO          _/_/_/
!     _/_/_/                                                        _/_/_/
!     _/_/_/     * ̓f[^F vf[^ (x, y, z U)       _/_/_/
!     _/_/_/                 F Measured2Plot3D.ctlit@Cj _/_/_/
!     _/_/_/                                                        _/_/_/
!     _/_/_/     * VOObh}`ObhtH[}bg   _/_/_/
!     _/_/_/                                                        _/_/_/
!     _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
!     _/_/_/                        T.Yoshida   Wed. Oct. 29, 2008  _/_/_/
!     _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
!
!/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
      program Measured2Plot3D           ! vf[^ PLOT3D ϊ

      parameter(mV=20, md1=20000, md2=20000, md3=20000)
      parameter(      mdd1=200, mdd2=200, mdd3=200)

      character(len=256) FileInput      ! ͌vt@C
      character(len=256) FileXYZ        ! xyz t@C
      character(len=256) FileFun        ! function t@C
      character(len=256) FileNam        ! nam t@C

      real*8   prec                     ! Wx 
      integer  nVars                    ! ǂݍ݁iojϐ
      integer  nVarFlag(mV)             ! ϐtOi vector or scalar)
      character(len=40) charVar(mV, 4)  ! ϐ񃊃Xg
      integer  nCount                   ! 

      integer nx, ny, nz                ! Z
      real*4    XX(0:md1)               ! 
      real*4    YY(0:md2)               ! 
      real*4    ZZ(0:md3)               ! 

      real*4   tmpVar(mV)               ! ꎟǂݍݗp
      real*4   tmpXYZ(3)                ! Wf[^ꎟǂݍ

      real*4 Vars(mdd1, mdd2, mdd3, mV) ! ϐf[^

      real*4    XC(mdd1)                ! ZlWz
      real*4    YC(mdd2)                ! 
      real*4    ZC(mdd3)                ! 

      integer   intX, intY, intZ        ! 

!!---

      call ReadCtrlFile(                ! t@C̓ǂݍ
     &     FileInput, FileXYZ, FileFun, FileNam,
     &     prec, nVars, nVarFlag, charVar, nCount, mV)

!!---

      call OutputNamFile(               ! t@C̓ǂݍ
     &     FileNam, nVars, nVarFlag, charVar, nCount, mV)

!!---
      call StoreXXYYZZ(                 ! Wf[^Zo
     &     FileInput, nx, ny, nz, XX, YY, ZZ, md1, md2, md3)


      call AscendingOrder(              ! ׂɂȂт
     &     nx, XX, md1)
      call Unique(                      ! d
     &     prec, nx, XX, md1)

      call AscendingOrder(              ! ׂɂȂт
     &     ny, YY, md2)
      call Unique(                      ! d
     &     prec, ny, YY, md2)
      call AscendingOrder(              ! ׂɂȂт
     &     nz, ZZ, md3)
      call Unique(                      ! d
     &     prec, nz, ZZ, md3)

      call OutputXYZ(                   ! xyz t@C̏
     &     FileXYZ, nx, ny, nz, XX, YY, ZZ, md1, md2, md3)

!!---
      call CheckDimensionOverFlow(      ! dimension check
     &     nx, ny, nz, mdd1, mdd2, mdd3)
!!---
      call InitializeVars(              ! 
     &     Vars, mdd1, mdd2, mdd3, mV)

!!---
      call MakeXcYcZc(                  ! 
     &     nx, ny, nz, XX, YY, ZZ, XC, YC, ZC,
     &     md1, md2, md3, mdd1, mdd2, mdd3)

!!---
      open(12, file=FileInput, status="old")
      read(12, *)                       ! read through
      nCount=0
      intX=-999
      intY=-999
      intZ=-999
      do
         read(12,*, iostat=intEOF)
     &      (tmpXYZ(i), i=1, 3),
     &      (tmpVar(i), i=1, nVars)
         if(intEOF /= 0)then            ! t@CI[
            exit
         else
            nCount=nCount+1
         end if

         call SearchGridPosition(       ! f[^ʒǔ
     &        intX, intY, intZ, tmpXYZ,
     &        nx, ny, nz, XC, YC, ZC, mdd1, mdd2, mdd3)

         call StoreVariables(           ! ϐl̖ߍ
     &        intX, intY, intZ, nVars, tmpVar, Vars,
     &        mdd1, mdd2, mdd3, mV)

      end do
      close(12)

!!---
      call OutputFunctionFile(          ! function t@C̏o
     &     FileFun, nx, ny, nz, nVars, Vars,
     &              mdd1, mdd2, mdd3, mV)


      stop
      end program


!/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
      subroutine ReadCtrlFile(          ! t@C̓ǂݍ
     &     FileInput, FileXYZ, FileFun, FileNam,
     &     prec, nVars, nVarFlag, charVar, nCount, mV)

!!---
      character(len=*)   FileInput      ! ͌vt@C
      character(len=*)   FileXYZ        ! xyz t@C
      character(len=*)   FileFun        ! function t@C
      character(len=*)   FileNam        ! nam t@C

      real*8   prec                     ! Wx 
      integer  nVars                    ! ǂݍ݁iojϐ
      integer  nVarFlag(mV)             ! ϐtOi vector or scalar)
      character(len=*) charVar(mV,4 )   ! ϐ񃊃Xg

      integer  nCount                   ! 

!!---

      open(99, file="Measured2Plot3D.ctl", status="old")
      read(99,*)                        ! read through
      read(99,"(a)") FileInput          !    input file
      read(99,"(a)") FileXYZ            !      XYZ file
      read(99,"(a)") FileFun            ! function file
      read(99,"(a)") FileNam            !      nam file
      read(99,*)  prec                  ! precision
      read(99,*)  nCount                ! 
      nVars=0
      do loop=1, nCount
!!         read(99,"(i1,1x,a)") nVarFlag(loop), charVar(loop)
         read(99,*) nVarFlag(loop), (charVar(loop, i), i=1, 4)
         if(nVarFlag(loop) == 0)then
            nVars=nVars + 1
         else if(nVarFlag(loop) == 1)then
            nVars=nVars + 3
         else
            write(*,*)"`.ctl format Ⴂ܂!"
            stop
         end if
!         write(*,*) nVarFlag(loop), (charVar(loop, i), i=1, 4)
      end do
      close(99)

!!---



!!---
      write(*,"(a70)") FileInput        !    input file
      write(*,"(a70)") FileXYZ          !      XYZ file
      write(*,"(a70)") FileFun          ! function file
      write(*,"(a70)") FileNam          !      nam file
      write(*,"(a7,e12.5)")  "  prec:",prec ! precision
      write(*,"(a7,i10)")    " nVars:",nVars! num of variable


      return
      end subroutine



!/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
      subroutine OutputNamFile(         ! t@C̓ǂݍ
     &     FileNam, nVars, nVarFlag, charVar, nCount, mV)

      character(len=*) FileNam          ! nam t@C
      integer  nVars                    ! ǂݍ݁iojϐ
      integer  nVarFlag(mV)             ! ϐtOi vector or scalar)
      character(len=40) charVar(mV, 4)  ! ϐ񃊃Xg
      integer  nCount                   ! 

!!---

      open(21, file=FileNam, status="unknown")
      do loop=1, nCount
         if(nVarFlag(loop) == 1)then
            write(21,"(a15,a3,a15)")
     &            charVar(loop, 2), " ; ", charVar(loop, 1)
            write(21,"(a)") charVar(loop, 3)
            write(21,"(a)") charVar(loop, 4)
         else if(nVarFlag(loop) == 0)then
            write(21,"(a)") charVar(loop, 1)
         end if
      end do
      close(21)

      return
      end subroutine



!/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
      subroutine StoreXXYYZZ(           ! Wf[^Zo
     &     FileInput, nx, ny, nz, XX, YY, ZZ, md1, md2, md3)

      character(len=*) FileInput        ! ͌vt@C
      integer nx, ny, nz                ! Z
      real*4    XX(0:md1)               ! 
      real*4    YY(0:md2)               ! 
      real*4    ZZ(0:md3)               ! 

!!---

      open(11, file=FileInput, status="old")
      read(11,*)                        ! read through

      nRow=1
      do
         read(11,*, iostat=intEOF)
     &        XX(nRow), YY(nRow), ZZ(nRow)
         if(intEOF /= 0)then            ! t@CI[
            exit
         else
            nRow=nRow+1
            if(nRow >= md1 .or.
     &         nRow >= md2 .or.
     &         nRow >= md3)then
              write(*,*) "md* is too small"
              write(*,*) "nRow:", nRow
              write(*,*) " md1:", md1
              write(*,*) " md2:", md2
              write(*,*) " md3:", md3
              stop
            end if

         end if
      end do

      close(11)

      nx=nRow
      ny=nRow
      nz=nRow


      return
      end subroutine



!/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
      subroutine AscendingOrder(        ! ׂɂȂт
     &     nList, XYZ, md)

      integer  nList                    ! 
      real*4   XYZ(0:md)

      real*4   tmp(0:md)
      integer  nFlag(0:md)              ! 0: ,  1: ς

!!---                                   ! initilization
      do loop=1, md
         tmp(loop)=0.0
         nFlag(loop)=0
      end do

!!---                                   ! copy
      do loop=1, md
         tmp(loop)=XYZ(loop)
      end do

!!---                                   ! initilization
      do loop=1, md
         XYZ(loop)=0.0
      end do

!!---
!!    write(*,*)"nList:",nList

      do list=1, nList                  ! Xgߕ loop 
         rMin=1.0e+5
         nMin=-999
         do loop=1, nList               ! ŏlo loop 
             if(tmp(loop) <= rMin .and. 
     &         nFlag(loop) == 0 )then      !   ŏl
               rMin=tmp(loop)
               nMin=loop
            end if
         end do
         nFlag(nMin)=1
         XYZ(list)=rMin
      end do

      return
      end subroutine


!/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
      subroutine Unique(                ! d
     &     prec, nList, XYZ, md)

      integer  nList                    ! 
      real*4   XYZ(0:md)
      real*4   tmp(0:md)
      real*8   prec                     ! Wx 

!!---                                   ! initilization
      do loop=1, md
         tmp(loop)=0.0
      end do

!!---                                   ! copy
      do loop=1, md
         tmp(loop)=XYZ(loop)
      end do

!!---                                   ! initilization
      do loop=1, md
         XYZ(loop)=0.0
      end do

!!---
!!    write(*,*)"nList:",nList

      XYZ(1)=tmp(1)
      nCount=1
      do loop=1, nList
         diff=abs(tmp(loop+1)-tmp(loop))
         if(diff > prec)then            ! Lӂȍ
            nCount=nCount+1
            XYZ(nCount)=tmp(loop+1)
         end if
      end do
      nList=nCount-1

      return
      end subroutine


!/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
      subroutine OutputXYZ(             ! xyz t@C̏
     &     FileXYZ, nx, ny, nz, XX, YY, ZZ, md1, md2, md3)

      character(len=*)   FileXYZ        ! xyz t@C
      integer nx, ny, nz                ! Z
      real*4    XX(0:md1)               ! 
      real*4    YY(0:md2)               ! 
      real*4    ZZ(0:md3)               ! 

!!---
      open(22, file=FileXYZ, status="unknown")
      write(22, "(i5)") 1
      write(22, "(3i8)") nx, ny, nz

      write(22,"(4(1x,f12.3))")
     &   (((XX(i), i=1, nx), j=1, ny), k=1, nz),
     &   (((YY(j), i=1, nx), j=1, ny), k=1, nz),
     &   (((ZZ(k), i=1, nx), j=1, ny), k=1, nz)

      close(22)

      return
      end subroutine

!/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
      subroutine CheckDimensionOverFlow(! dimension check
     &     nx, ny, nz, mdd1, mdd2, mdd3)
!!---
      if(nx > mdd1)then
         write(*,*) "mdd1 is too small"
         stop
      end if

      if(ny > mdd2)then
         write(*,*) "mdd2 is too small"
         stop
      end if

      if(nz > mdd3)then
         write(*,*) "mdd3 is too small"
         stop
      end if

      return
      end subroutine


!/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
      subroutine InitializeVars(        ! Vars z̏
     &     Vars, mdd1, mdd2, mdd3, mV)

      real*4 Vars(mdd1, mdd2, mdd3, mV) ! ϐf[^

!!---
      do loop=1, mV
         do k=1, mdd3
            do j=1, mdd2
               do i=1, mdd1
                  Vars(i,j,k,loop)=0.0
               end do
            end do
         end do
      end do


      return
      end subroutine


!/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
      subroutine MakeXcYcZc(            ! 
     &     nx, ny, nz, XX, YY, ZZ, XC, YC, ZC,
     &     md1, md2, md3, mdd1, mdd2, mdd3)

      integer nx, ny, nz                ! Z
      real*4    XX(0:md1)               ! 
      real*4    YY(0:md2)               ! 
      real*4    ZZ(0:md3)               ! 

      real*4    XC(mdd1)                ! ZlWz
      real*4    YC(mdd2)                ! 
      real*4    ZC(mdd3)                ! 

!!---

      do loop=1, nx-1
         XC(loop)=0.5*(XX(loop+1)+XX(loop))
      end do

      do loop=1, ny-1
         YC(loop)=0.5*(YY(loop+1)+YY(loop))
      end do

      do loop=1, nz-1
         ZC(loop)=0.5*(ZZ(loop+1)+ZZ(loop))
      end do

      return
      end subroutine


!/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
      subroutine SearchGridPosition(    ! f[^ʒǔ
     &        intX, intY, intZ, tmpXYZ,
     &        nx, ny, nz, XC, YC, ZC, mdd1, mdd2, mdd3)

      real*4   tmpXYZ(3)                ! Wf[^ꎟǂݍ
      real*4    XC(mdd1)                ! ZlWz
      real*4    YC(mdd2)                ! 
      real*4    ZC(mdd3)                ! 

      integer nx, ny, nz                ! Z
      integer   intX, intY, intZ        ! 

      real*4    XCM(0:mdd1)             ! ZlWz
      real*4    YCM(0:mdd2)             ! * [ɕ֋XIɐl}
      real*4    ZCM(0:mdd3)             ! 

!!---                                   ! Rs[
      do loop=1, nx-1
         XCM(loop)=XC(loop)
      end do
      XCM(0)=-XCM(1)
      XCM(nx)=XCM(nx-1)+(XCM(nx-1)-XCM(nx-2))

      do loop=1, ny-1
         YCM(loop)=YC(loop)
      end do
      YCM(0)=-YCM(1)
      YCM(ny)=YCM(ny-1)+(YCM(ny-1)-YCM(ny-2))

      do loop=1, nz-1
         ZCM(loop)=ZC(loop)
      end do
      ZCM(0)=-ZCM(1)
      ZCM(nz)=ZCM(nz-1)+(ZCM(nz-1)-ZCM(nz-2))

!!---
      searchX : do loop=1, nx
         if(tmpXYZ(1) > XCM(loop-1) .and.
     &      tmpXYZ(1) < XCM(loop))then
            intX=loop
            exit searchX
         end if
      end do searchX

      searchY : do loop=1, ny
         if(tmpXYZ(2) > YCM(loop-1) .and.
     &      tmpXYZ(2) < YCM(loop))then
            intY=loop
            exit searchY
         end if
      end do searchY

      searchZ : do loop=1, nz
         if(tmpXYZ(3) > ZCM(loop-1) .and.
     &      tmpXYZ(3) < ZCM(loop))then
            intZ=loop
            exit searchZ
         end if
      end do searchZ

      return
      end subroutine


!/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
      subroutine StoreVariables(        ! ϐl̖ߍ
     &        intX, intY, intZ, nVars, tmpVar, Vars,
     &        mdd1, mdd2, mdd3, mV)

      integer   intX, intY, intZ        ! 
      integer  nVars                    ! ǂݍ݁iojϐ
      real*4   tmpVar(mV)               ! ꎟǂݍݗp
      real*4 Vars(mdd1, mdd2, mdd3, mV) ! ϐf[^

!!---
      do loop=1, nVars
         Vars(intX, intY, intZ, loop)=tmpVar(loop)
      end do

      return
      end subroutine



!/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
      subroutine OutputFunctionFile(    ! function t@C̏o
     &     FileFun, nx, ny, nz, nVars, Vars,
     &              mdd1, mdd2, mdd3, mV)

      character(len=*) FileFun          ! function t@C
      integer nx, ny, nz                ! Z
      integer  nVars                    ! ǂݍ݁iojϐ
      real*4 Vars(mdd1, mdd2, mdd3, mV) ! ϐf[^
!!---

      open(23, file=FileFun, status="unknown")
      write(23, "(i8)") 1               ! }`ObhtH[}bg
                                        !  Obh 1 
      write(23, "(4i8)") nx, ny, nz, nVars

      do loop=1, nVars
         write(23, "(4(1x, f12.3))")
     &        (((Vars(i, j, k, loop), i=1, nx),
     &                                j=1, ny),
     &                                k=1, nz)
      end do

      close(23)


      return
      end subroutine
