# coding: utf-8
# -----------------------------------------------------------------------
# --
# -- Copyright (c) 2010 VINAS
# -- All rights reserved.
# --
# -- This sample FieldView Python script is not supported
# --                                     by VINAS and VINAS provides
# -- no warranties or assurances about its fitness or merchantability.
# -- It is provided at no cost and is for demonstration purposes only.
# --
# -----------------------------------------------------------------------

import sys
print("Python version is ", sys.version)

from fv import *


print ("---- Python Sample PY112 ----")


## define data input table 
data_input_table  =  {
	'data_format' :   "unstructured",
	'input_parameters' :   {
			'name' :   './rect_duct_001.uns',
			'options' :   {
				'input_mode' :   "replace",
				'transient' :   "on"
				#'transient' :   "off"
		                  },
	                   }
                    }


## call function to read dataset
read_dataset(data_input_table)


## define coordinate surface table
coord_table = {
	'dataset' : 1,
	'scalar_func' : "temperature",
	'axis' : "Z",
	'Z_axis' : { 'current' : 0.0127},
	'display_type' : "smooth_shading",
	}



## create coordinate surface
create_coord(coord_table)


## save restart files
fv_script("SAVE ALL sample")

##---------------------------------------------------------------------
##   FAQ PY112 : annotation
##---------------------------------------------------------------------

anno_table={
	'text' : 'annotation sample',
	'font' : 'helvetica',
	'size' : 14,
#	'position' : "center",
	'position' : {1:400, 2:625},
	'geometric_color' : 'white',
	}

create_text(anno_table)




