# coding: utf-8
# -----------------------------------------------------------------------
# --
# -- Copyright (c) 2011 VINAS
# -- All rights reserved.
# --
# -- This sample FieldView Python script is not supported
# --                                     by VINAS and VINAS provides
# -- no warranties or assurances about its fitness or merchantability.
# -- It is provided at no cost and is for demonstration purposes only.
# --
# -----------------------------------------------------------------------

import sys
print("Python version is ", sys.version)

from fv import *


print ("-------------------------------------------")
print ("---- Python Sample : PY118 sample02.py ----")
print ("-------------------------------------------")


## define data input table 
data_input_table  =  {
	'data_format' :   "unstructured",
	'input_parameters' :   {
			'name' :   './rect_duct_001.uns',
			'options' :   {
				'input_mode' :   "replace",
				'transient' :   "on"
				#'transient' :   "off"
		                  },
	                   }
                    }


## call function to read dataset
read_dataset(data_input_table)


CurrentZ=0.0050
deltaZ=0.005
nCoord=4


for i in range(1, nCoord+1, 1) :

	print ("-------------------")
	strCurrentZ="CurrentZ: %7.5f \n " % CurrentZ
	print strCurrentZ,


	## define coordinate surface table
	coord_table = {
		'dataset' : 1,
		'scalar_func' : "temperature",
		'transparency' : 0.5,
		'axis' : "Z",
		#'Z_axis' : { 'current' : 0.0127},
		'Z_axis' : { 'current' : CurrentZ},
		'display_type' : "smooth_shading",
		}

	## create coordinate surface
	crd_handle=create_coord(coord_table)

	## save image files
	strCmd="PRINT GRAPHICS JPEG sample02_%3.3d.jpg \n " % i
	fv_script(strCmd)

	## clear dictionary
	delete(crd_handle)

	CurrentZ=CurrentZ+deltaZ

#end






