#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "getopt.h"
#include "gettoken.h"

#define         LITTLE_ENDIAN   1
#define         BIG_ENDIAN      0
#define         FV_MAGIC		0x00010203

int  debug=0;
int	scale_factor_flag;
float scale_factor;
static char input_file_name[256][256];
static char output_file_name[256];
static int	input_file_count=0;
static char time_step_char[256][256];
static int  byte_order;
static int  bswap_input;
static int  bswap_output;

/***********************
 ***  ABNORMAL STOP  ***
 **********************/
void error_stop( msg )
	char *msg;	/* ERROR MESSAGE */
{
        fprintf(stderr,"fvconv : %s\n",msg );
        exit (-1);
}
/********************************
 *** Remove '"' from strings ***
/********************************/
remove_quote( str )
	char	*str;
{
	char	*p;

	p = str;

	while( *p == ' ' || *p=='\"' || *p=='\'' ) p++;

	while( *p!='|' && *p!='\"' && *p!='\'' && *p != '\000' ) {
		*str ++ = *p++;
	}
	*str = '\000';
}
/******************************************
 *** Remove first-last-' ' from strings ***
/******************************************/
void  remove_space(char *str)
{
    char *p, *q;
    size_t n;

    p = str;
    n = strlen(p);
    while (n--) {
        if (*p == ' ' )  {
            q = p + 1;
            memmove(p, q, strlen(q));
            n--;
        } else {
			break;
		}
        p++;
    }

    n = strlen(p);
	p+=n-1;
    while (n--) {
        if (*p == ' ' || *p == '\n' || *p == '\r' )  {
/*		    *p = 'A'; */
		    *p = '\0';
            n--;
        } else {
			break;
		}
        p--;
    }

}

/***********************
 ***  strlwr         ***
 **********************/
char *strlwr (char *s)
{
	char *origs = s;
	while (*s) {
		*s = tolower(*s);
		s++;
	}
	return origs;
}

/***********************
 ***  BYTE SWAP      ***
 **********************/
int     byte_order_test()
{
        union {
                unsigned char   byte[4];
                unsigned int    word;
        } tst;

        tst.byte[0] = 1;
        tst.byte[1] = 2;
        tst.byte[2] = 3;
        tst.byte[3] = 4;

        if( tst.word == 0x01020304 ) return( BIG_ENDIAN );
        else                         return( LITTLE_ENDIAN );
}

void bswap( ptr )
        unsigned int    *ptr;
{
        unsigned int    t, t1;

        t       = (*ptr) >> 16;
        t1      = ( t >> 8) | ( ( t & 0xff) << 8 );
        t       = ( (*ptr) << 16 );
        *ptr    = t1 | ( t << 8 ) | ( ( t & 0xff000000 ) >> 8 );
}

void nbswap( ptr, n )
        unsigned char    *ptr;
        size_t          n;
{
	size_t i=n;
	unsigned char b[16];
	
	while( i-- != 0 ) {
		b[i]=ptr[n-i-1];
	}
	while( n-- != 0 ) {
		ptr[n]=b[n];
	}

}

void bswapn( ptr, n )
        unsigned int    *ptr;
        size_t          n;
{
        while( n-- != 0 ) bswap( ptr++ );
}

void nbswapn( ptr, size, n )
        unsigned char    *ptr;
        size_t  size;
        size_t          n;
{
        while( n-- != 0 ) nbswap( ptr++, size );
}
/***********************
 ***  READ 1BYTE      ***
 **********************/
int hf_read(fp)
FILE *fp;
{
	int		rtc;
	int		idum ;

	rtc = fread(&idum,sizeof(int),1,fp) ;
    if( bswap_input) nbswapn( &idum, 4, rtc );

    return (idum) ;
/*    return (rtc) ; */
}
/*
** fread_str80:  write out a string padded to 80 characters.
**
** Like fread, this returns the number of items written, which
** should be 80 if successful, and less than 80 if it failed.
*/
#ifdef __STDC__
size_t fread_str80 (char *str, FILE *fp)
#else
int fread_str80 (str, fp)
char *str;
FILE *fp;
#endif
{
    char cbuf[80];
    size_t len;
    unsigned int i;

	fread(cbuf, 80, 1, fp);
    strncpy(str, cbuf, 80);
    len = strlen(str);

    for (i = 80; i < len; i++)
        str[i] = '\0';  /* pad with zeros */

    return 1;
}
/*
** fwrite_str80:  write out a string padded to 80 characters.
**
** Like fwrite, this returns the number of items written, which
** should be 80 if successful, and less than 80 if it failed.
*/
#ifdef __STDC__
size_t fwrite_str80 (char *str, FILE *fp)
#else
int fwrite_str80 (str, fp)
char *str;
FILE *fp;
#endif
{
    char cbuf[80];
    size_t len;
    int i;

    /* Most of this just to avoid garbage after the name. */
    len = strlen(str);
    strncpy(cbuf, str, len < 80 ? len : 80);

    for (i = len; i < 80; i++)
        cbuf[i] = '\0';  /* pad with zeros */

    return fwrite(cbuf, sizeof(char), 80, fp);
}

/**********************************
 *** FILE I/O With BYTE-SWAPING ***
 *********************************/
size_t bswap_fread( ptr, size, n, fp )
        void    *ptr;
        size_t  size;
        size_t  n;
        FILE    *fp;
{
		size_t  rtc;
		fpos_t pos;

		rtc = fread( ptr, size, n, fp );
        if( bswap_input && size == 4 ) nbswapn( ptr, size, rtc );
        else if( bswap_input && size == 8 ) nbswapn( ptr, size, rtc );
        else if( bswap_input && size == 16) nbswapn( ptr, size, rtc );

		if( debug && rtc!=1 ) {
			fgetpos( fp, &pos );
			printf( "G[ӏ%I64d oCgł\n", pos );
		}

        return( rtc );
}
size_t bswap_fwrite( ptr, size, n, fp )
        void    *ptr;
        size_t  size;
        size_t  n;
        FILE    *fp;
{
        size_t  rtc;

        if( bswap_output && size == 4 ) nbswapn( ptr, size, n );
        else if( bswap_output && size == 8 ) nbswapn( ptr, size, n );
        else if( bswap_output && size == 16) nbswapn( ptr, size, n );
        rtc = fwrite( ptr, size, n, fp );
        if( bswap_output && size == 4 ) nbswapn( ptr, size, n );
        else if( bswap_output && size == 8 ) nbswapn( ptr, size, n );
        else if( bswap_output && size == 16) nbswapn( ptr, size, n );
        return( rtc );
}
/**********************************
 *** CONVERT *.fvp              ***
 *********************************/

int convert_fvp_txt_to_bin( in_fp, out_fp, iflag)
	FILE	*in_fp;
	FILE	*out_fp;
	int		iflag;
{
	int PP_MAJOR;
	int PP_MINOR;
    int TOTAL_PTCL;
    int NPTCL;
    int NPATH;
    int NTAG;
    int NLABEL;
	int FDiameter=-1;
    int ibuf[2] ;
	char *LTAG;
	char LLVER[100][80];
	char str_80[81];
	char str_1024[1024];
	float *x, *y, *z;
    float *fbuf ;
    static int	time_step=0 ;
	static float solution_time=0.0f;
    int i, j, cnt;
    int time_flag=-1;
	float ave_time=0.0f;
	fpos_t pos;

	NPATH=1;
    /* PPREAD DATA */
    /* Output the magic number. */
    fscanf ( in_fp,"%s %d %d ", str_80, &PP_MAJOR, &PP_MINOR);

    /* Output file header and version number. */
	if(debug==1) printf("PART: %s\n",str_80);
	if(debug==1) printf("MAJOR_VERSION_BIN: %d\n", PP_MAJOR);
	if(debug==1) printf("MINOR_VERSION: %d\n", PP_MINOR);
	/*printf("%d\n",ibuf[0]) ;*/

    if(PP_MAJOR!=1 && PP_MAJOR!=2) {
		printf("This file may not be a FIELDVIEW Particle Path(*.fvp)\n");
		exit(1);
	}
 
    /* Number of tags (after FVPARTICLE 2 1) */
    if(PP_MAJOR==2) {
		fgets(str_80, 80, in_fp);
		fscanf ( in_fp, "%d ", &NTAG);
		if(debug==1) printf("NTAG: %d\n",NTAG) ;

		LTAG = (char *)malloc(NTAG*sizeof(char));
		/* tag name	. */
		for(i=0;i<NTAG;i++){
		    fgets(str_80, 80, in_fp);
			LTAG[i] = *(char *)malloc(sizeof(char) * (strlen(str_80)+1));
			strcpy(&LTAG[i], str_80);
			if(debug==1) printf("LTAG[%d]: %s",i, &LTAG[i]) ;
		}
	}

    /* Number of variables */
    fgets(str_80, 80, in_fp);
    fscanf ( in_fp, "%d ", &NLABEL);
    if(debug==1) printf("NLABEL: %d\n",NLABEL) ;
/*
	LLVER = (char **)malloc(NLABEL*sizeof(char));
*/
    /* variable name */
	time_flag=-1;
    for(i=0;i<NLABEL;i++){
	    fgets(str_80, 80, in_fp);
/*
		LLVER[i] = (char *)malloc(sizeof(char) * (strlen(str_80)+1));
*/
		remove_space(str_80);
		if( strstr(strlwr(str_80), "time")!=NULL ) {
			strcat(str_80, "(FVP)");
			time_flag=i;
		}
		strcpy(LLVER[i], str_80);
		if(debug==1) printf("LLVER[%d]: %s",i, LLVER[i]);

    }
	/* check time value */
	if ( time_flag < 0 ) {
		printf("Error: input ASCII *.fvp does not have \"TIME\" values.\n");
		exit(1);
	}

	/* count all particles */
	cnt=0;
	fgetpos( in_fp,  &pos );
	while( !feof( in_fp ) ) {
		fscanf(in_fp, "%d ", &NPTCL);
		if(feof(in_fp)) break;
        if(PP_MAJOR==2) {
		    fgets(str_1024, 1024, in_fp);
		}
		for(i=0; i<NPTCL; i++){
		    fgets(str_1024, 1024, in_fp);
			cnt++;
		}
	}
	fsetpos( in_fp,  &pos );
	TOTAL_PTCL=cnt;
/*	TOTAL_PTCL=cnt-1; */
    if(debug==1) printf("TOTAL_PTCL: %d\n", TOTAL_PTCL) ;


	/* ***************** */
	/* MEMORY ALLOCATION */
	/* ***************** */
	x     =(float *)malloc(TOTAL_PTCL*sizeof(float));
	y     =(float *)malloc(TOTAL_PTCL*sizeof(float));
	z     =(float *)malloc(TOTAL_PTCL*sizeof(float));
	fbuf = (float *)malloc(NLABEL*TOTAL_PTCL*sizeof(float));
	if(fbuf==NULL) {
		error_stop ( "Memory allocation error" );
	}
	/* Read Particle Data */
	cnt=0;
	ave_time=0.0f;
	while( !feof( in_fp ) ) {
		fscanf(in_fp, "%d ", &NPTCL);

        if(PP_MAJOR==2) {
		    fscanf ( in_fp, "%d ", &ibuf[0]);
		}

		for(i=0; i<NPTCL; i++){
			fscanf(in_fp, "%f %f %f ", &x[cnt], &y[cnt], &z[cnt]);
			for(j=0; j<NLABEL; j++){
				fscanf ( in_fp,"%f ", &fbuf[cnt*NLABEL+j]);
				if(j==time_flag) {
					ave_time+=fbuf[cnt*NLABEL+j];
				}
			}
			cnt++;
		}
			
	}
	/* define solution_time */
	solution_time=ave_time/(float)cnt;


	/* Write ---------------------------------------------------------------------- */

	if(debug==1) printf("writing...\n");
	if(iflag==0) {
		if(debug==1) printf(".................\n");
		/* Output the magic number. */
		ibuf[0]=FV_MAGIC;
		fwrite(ibuf, sizeof(int), 1, out_fp);
		if(debug==1) printf("FV_MAGIC: %d\n",ibuf[0]);

		/* Output file header and version number. */
		strncpy(str_80, "FVPARTICLES", 80);
		fwrite_str80(str_80, out_fp);
		if(debug==1) printf("PART: %s\n",str_80);
		PP_MAJOR=1;
		fwrite(&PP_MAJOR, sizeof(int), 1, out_fp);
		if(debug==1) printf("MAJOR_VERSION_BIN: %d\n", PP_MAJOR);
		PP_MINOR=1;
		fwrite(&PP_MINOR, sizeof(int), 1, out_fp);
		if(debug==1) printf("MINOR_VERSION: %d\n", PP_MINOR);
		/*printf("%d\n",ibuf[0]) ;*/

		/* Number of tags (after FVPARTICLE 2 1) */
		NTAG=0;
		LTAG="";
		if(PP_MAJOR==2) {
			/* NO tags */
		}

		/* Number of variables */
		fwrite(&NLABEL, sizeof(int), 1, out_fp);
		if(debug==1) printf("NLABEL: %d\n",NLABEL) ;

		/* variable name */
		for(i=0;i<NLABEL;i++){
			strcpy(str_80, LLVER[i]);
			fwrite_str80(str_80, out_fp);
			if(debug==1) printf("LLVER[%d]: %s\n",i, LLVER[i]);

		}
	}


	/* Write Particle Data */
	/* time step number */
	time_step=atoi(time_step_char[iflag]);
	fwrite(&time_step, sizeof(int), 1, out_fp);
	/* solution time */
	fwrite(&solution_time, sizeof(float), 1, out_fp);
	/* number of particles */
	fwrite(&TOTAL_PTCL, sizeof(int), 1, out_fp);	
	printf(" ------------------------------------------------\n") ;
	printf(" time_step %d   TIME=%f  TOTAL_PTCL=%d\n",time_step,solution_time,TOTAL_PTCL) ;
    if(PP_MAJOR==2) {
		/* NO tags */
	}

	for(i=0; i<TOTAL_PTCL; i++){
		ibuf[0]=i+1;
		fwrite(ibuf,  sizeof(int),   1, out_fp);
		fwrite(&x[i], sizeof(float), 1, out_fp);
		fwrite(&y[i], sizeof(float), 1, out_fp);
		fwrite(&z[i], sizeof(float), 1, out_fp);
		for(j=0; j<NLABEL; j++){
			fwrite(&fbuf[i*NLABEL+j], sizeof(float), 1, out_fp);
		}
	}


	fgetpos( in_fp,  &pos );
	printf( "%I64d oCgǂ݂܂\n", pos );
	fgetpos( out_fp, &pos );
	printf( "%I64d oCg݂܂\n", pos );

	return 1;
}

/*****************************
 ***    MESSAGE OF USAGE   ***
 ****************************/
void usage( fp )
        FILE *fp;        /* where to display message */
{
        fprintf(fp,"FVPCOMBINE V1.0 \n");
        fprintf(fp,"usage : fvpcombine OPT [IN-FILE [IN-FILE...]]\n\n");
        fprintf(fp,"OPT:           -? or -h      this message\n");
        fprintf(fp,"               -s            swap output\n");
        fprintf(fp,"               -v            debug mode\n");
        fprintf(fp,"               -f [rate]     scaling facter\n");
        fprintf(fp,"\n");
}

extern char	*optarg;
extern int	optind;
/***************************************
 ***   ANALYSYS COMMAND LINE OPTION  ***
 **************************************/
void option_set( argc, argv )
        int argc;        /* number of arg. */
        char *argv[];   /* arg. */
{
        int  cc;
		int  n, cn;
		char buffer[256];

		debug             = 0;
		bswap_output      = 0;
		scale_factor_flag = 0;
		scale_factor      = 1.0;

        while ( ( cc = getopt(argc,argv,"v?hsarf:") ) !=  EOF ) {

                switch ( cc ) {

                  case '?':     usage(stdout);  exit (0);
                  case 'h':     usage(stdout);  exit (0);

                  case 's':     bswap_output = 1;
                                break;
                  case 'f':     sscanf( optarg, "%f", &scale_factor );
		                  		scale_factor_flag = 1;
                                break;

                  case 'v':     debug = 1;
				                break;

                  default:      usage(stderr);
                                error_stop("unKnown option");
                                break;
                }
        }


        if ( argc > 1 && optind < argc ) {

			while( optind < argc ) {
				strncpy( buffer, argv[optind], 256 );
				remove_quote( buffer );

				if( buffer[0] != (int)NULL ) {
					/***************************************
					**  INPUT FILE NAME                   **
					***************************************/
					strncpy(  input_file_name[input_file_count], buffer, 256);
					strncpy(  gt_line, buffer, 256);
					get_token();
					while(1){
						get_token();
						if(*token == '\0')		/* 1sI */
							break;
						if(*token == '\n')
							printf("(\\n)");	/* sR[h */
						else if(strcmp(token, "no_digits")!=0) {
							strcpy(time_step_char[input_file_count], token);
/*							printf("(%s) ", token);	/* \ */
						}
					}


					if (output_file_name[0] ==(int)NULL ) {
						strncpy( output_file_name, buffer, 256);

						/* create fin_grid/result_name */
						n = strlen( output_file_name );
						if( strcmp( &(output_file_name[n-4]), ".fvp"   ) == 0 ) {
								   output_file_name[n-4] = (int)NULL;
						}
						n = strlen( output_file_name );
						/* cn = strlen(token) */
						cn = strlen(time_step_char[input_file_count]);
						if(n<cn) cn=n;
						if( strcmp( &(output_file_name[n-cn]), time_step_char[input_file_count] ) == 0 ) {
								   output_file_name[n-cn] = (int)NULL;
						}
						n = strlen( output_file_name );
						strcpy( &(output_file_name[n]), "_bin.fvp" );
					}
					input_file_count++;
				}
				optind++;
			}

		}



		return;
}
/***************************************
 ***   MAIN                          ***
 **************************************/
void main(argc, argv)
	int argc;
	char *argv[];
{
	int i;
	FILE	*in_fp, *out_fp;

	byte_order = byte_order_test();
    bswap_input  = 0;
    bswap_output = 0;

    option_set ( argc, argv );

	printf("---\n");
	for (i = 0; i < input_file_count; i++){
		printf("Input File:%s   --->  Output File:%s\n",input_file_name[i], output_file_name);
	    /* OPEN FOR INPUT FILE */
        if ( input_file_name[i][0] != 0 ) {
                in_fp = fopen ( input_file_name[i], "r" );
                if ( in_fp == NULL ) error_stop ( "input file open error" );
        } else {
                in_fp = stdin;
        }

		if(i==0) {
			 /* OPEN FOR OUTPUT FILE */
			if ( output_file_name[0] != 0 ) {
					out_fp = fopen ( output_file_name, "wb" );
					if ( out_fp == NULL ) error_stop ( "output file open error" );
			} else {
					out_fp = stdout;
			}
		}

		convert_fvp_txt_to_bin( in_fp, out_fp, i );

		/* CLOSE FILE */
	    fclose(in_fp);
	}

	/* CLOSE FILE */
    fclose(out_fp);


}
