/*
 * gettoken.c - ͊֐Q Ver 1.3
 *  1996,1998 (C) Hiroshi Masuda
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define STR_MAX 256			/* 1s̍ő咷 */
#define EUC         1
#define SJIS1		2
#define SJIS2		3
#ifdef UNIX
	#define	KANJI1	EUC
	#define KANJI2	EUC
#else
	#define	KANJI1	SJIS1
	#define KANJI2	SJIS2
#endif

/* O[oϐ */
char	gt_line[STR_MAX];	/* get_token()p1sf[^obt@ */
char	token[STR_MAX];		/* 擾g[N */
/* vg^Cv錾 */
char *get_token(void);              /* g[N肾 */
void unget_token(char *);           /* g[N߂ */
int iskanji(int, unsigned char);	/* R[h̔ */

char *get_token(void)
{
	char	*p, *ptk, ch;

	p = gt_line;		/* |C^̏ */
	ptk = token;		/* |C^̏ */
	while(*p == ' ' || *p == '\t')	/* 󔒂ǂݔ΂ */
		++p;
	if(*p == '\0'){			/* obt@ */
		token[0] = '\0';
		return(token);
	}
	/* -----  ----- */
	if(iskanji(KANJI1, *p)){
		do{
			*ptk++ = *p++;			/* 1oCg */
			if(!iskanji(KANJI2, *p)){	/* 2oCg */
				printf("R[hsł\n");
				exit(1);
			}
			*ptk++ = *p++;
		}while(iskanji(KANJI1, *p) && *p != '\0');
    /* ----- p p ----- */
	}else if(isalpha(*p)){
		do{
			*ptk++ = *p++;
		}while(isalpha(*p) && *p !='\0');	/* 2ڈȍ~͉p */
/*		}while(isalnum(*p) && *p !='\0');	/* 2ڈȍ~͉p */
	/* -----  ----- */
    }else if(isdigit(*p) || *p == '+' || *p == '-'){
		do{
			*ptk++ = *p++;
		}while( isdigit(*p) && *p !='\0');
	    *ptk = '\0';        /* I[t */
		strcpy(gt_line, p);	/* c̕obt@ɃRs[ */
		return(token);
/*		}while((isdigit(*p) || *p == '.' || toupper(*p) == 'E') && *p !='\0'); */
	/* ----- E萔 ----- */
	}else if(*p == '\'' || *p == '"'){
		ch = *p;
		*ptk++ = *p++;
		do{
            if(*p == '\\'){         /* GXP[v */
				*ptk++ = *p++;
				*ptk++ = *p++;
            }else if(*p != '\n')    /* sR[h */
				*ptk++ = *p++;
		}while(*p != ch);
        ++p;
	/* ----- ̑̕ ----- */
	}else
		*ptk++ = *p++;
    *ptk = '\0';        /* I[t */
	strcpy(gt_line, p);	/* c̕obt@ɃRs[ */
	strcpy(token, "no_digits");	/* c̕obt@ɃRs[ */
	return(token);
}
void unget_token(char *t)
{
	char	work[STR_MAX];

    strcpy(work, t);        /* ߂g[NworkɃRs[ */
    if(*t == '\'' || *t == '"'){
        t[1] = '\0';
        strcat(work, t);
    }
	strcat(work, gt_line);	/* work1s̃f[^A */
	strcpy(gt_line, work);	/* work1sf[^ɃRs[ */
}
int iskanji(int type, unsigned char code)
{
	int	ret = 0;
	switch(type){
		case EUC:
			if((code >= 0xa1 && code <= 0xfe))
				ret = code;
			break;
		case SJIS1:
			if((code >= 0x81 && code <= 0x9F) || (code >= 0xe0 && code <= 0xfc))
				ret = code;
			break;
		case SJIS2:
			if((code >= 0x40 && code <= 0x7e) || (code >= 0x80 && code <= 0xfc))
				ret = code;
			break;
		default:
			printf("iskanji:unknown Kanji code type.\n");
			exit(1);
	}
	return(ret);
}

