!!-----------------------------------------------------------------------
!!--
!!-- Copyright (c) 2010 VINAS
!!-- All rights reserved.
!!--
!!-- This sample fortran script is not supported
!!--                                by VINAS and VINAS provides
!!-- no warranties or assurances about its fitness or merchantability.
!!-- It is provided at no cost and is for demonstration purposes only.
!!--
!!--
!!--                                          Meridional2FVUNS.f
!!--
!!--                                          T.Y.   Wed. June 16, 2010 
!!--
!!----------------------------------------------------------------------

!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      program Meridional2FVUNS          ! 

      parameter(md1=1071155, md2=100385)
!!---
      character(len=256) FileInput      ! input Export file
      character(len=256) FileOutput     ! output FV-UNS file
!!---
      integer  nPlot                    ! number of plot points
      integer  nPatch                   ! number of patches
!!---
      integer  nFlag                    ! projection flag
                                        !  1: I, 2: J, 3: K
!!---
      real*4   Xarray(md1)              ! array of X
      real*4   Yarray(md1)              ! array of Y
      real*4   Zarray(md1)              ! array of Z
      real*4   Sarray(md1)              ! array of Scalar
      real*4   Uarray(md1)              ! array of U
      real*4   Varray(md1)              ! array of V
      real*4   Warray(md1)              ! array of W
      real*4   Tarray(md1)              ! array of Z
!!---
      integer  nRectangle(md2,5)        ! vertex list
                                        ! 1-4 ... base triangle
                                        ! 5   ... crest node

!!---
!!---
      call ReadCtrlFile(                ! read control file
     &     FileInput, FileOutput)


      call DetectProjectDirection(      ! projection direction detect
     &     nFlag, FileInput)
      write(*,*)"nFlag:", nFlag

      call ReadVertexData(              ! read vertex data
     &     FileInput, nPlot,
     &     Xarray, Yarray, Zarray, Sarray,
     &     Uarray, Varray, Warray, Tarray, md1)

      call Project2D(                   ! 2D projection
     &     nFlag, nPlot, 
     &     Xarray, Yarray, Zarray, Sarray,
     &     Uarray, Varray, Warray, Tarray, md1)

      call ReadPatchData(               ! read patch data
     &     FileInput, nPatch, nRectangle, md2)

      call OutputFVUNS(                ! output FV-UNS file
     &     FileOutput,
     &     nPlot, Xarray, Yarray, Zarray, Sarray,
     &            Uarray, Varray, Warray, Tarray,
     &     nPatch, nRectangle, md1, md2)



      stop
      end program


!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine ReadCtrlFile(          ! control file の読み込み
     &     FileInput, FileOutput)

      character(len=*) FileInput        ! input Export file
      character(len=*) FileOutput       ! output FV-UNS file

!!---
      write(*,*) "sub : ReadCtrlFile"
!!---
      open(99,file='./Meridional2FVUNS.ctl',status='old')

      read(99,*)                        ! read through
      read(99,'(a)') FileInput
      read(99,'(a)') FileOutput
      close(99)

      write(*,*)           '-------------------------------------------'
      write(*,*)           '-----        Meridional2FVUNS.f    --------'
      write(*,*)           '-------------------------------------------'
      write(*,"(a20,a40)") ' input Export file :',FileInput
      write(*,"(a20,a40)") 'output FV-UNS file :',FileOutput
      write(*,*)           '--------------------'
      write(*,*)           ''

      return
      end subroutine


!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine DetectProjectDirection(! projection direction detect
     &     nFlag, FileInput)

      character(len=*) FileInput        ! input Export file
      integer  nFlag                    ! projection flag
      character(len=4) strGrid          ! header "Grid"
      character(len=1) strDirec         ! header "I, J, K"
!!---
      open(11, file=FileInput, status="old")
      read(11,"(a4,i2,1x,a1)") strGrid, n, strDirec
      close(11)
!!---
      write(*,"(a4,i2,1x,a1)") strGrid, n, strDirec
!!---
      if(strDirec == "I") then
         nFlag=1
      else if(strDirec == "J") then
         nFlag=2
      else if(strDirec == "K") then
         nFlag=3
      end if
!!---

      return
      end subroutine


!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine ReadVertexData(        ! read vertex data
     &     FileInput, nPlot,
     &     Xarray, Yarray, Zarray, Sarray,
     &     Uarray, Varray, Warray, Tarray, md1)

      character(len=*) FileInput        ! input Export file
      integer  nPlot                    ! number of plot points
      real*4   Xarray(md1)              ! array of X
      real*4   Yarray(md1)              ! array of Y
      real*4   Zarray(md1)              ! array of Z
      real*4   Sarray(md1)              ! array of Scalar
      real*4   Uarray(md1)              ! array of U
      real*4   Varray(md1)              ! array of V
      real*4   Warray(md1)              ! array of W
      real*4   Tarray(md1)              ! array of Z

      character(len=50) charCheck

!!---
      write(*,*) "sub : ReadVertexData"
!!---
      do loop=1, md1
         Xarray(loop)=0.0
         Yarray(loop)=0.0
         Zarray(loop)=0.0
         Sarray(loop)=0.0
         Uarray(loop)=0.0
         Varray(loop)=0.0
         Warray(loop)=0.0
         Tarray(loop)=0.0
      end do
!!---
      open(11, file=FileInput, status="old")
      do loop=1, 1
         read(11,"(a)") charCheck       ! skip header
         write(*,*) charCheck
      end do
      read(11,*) nPlot
      write(*,*) "nPlot:", nPlot
      read(11,*)                        ! skip header
      do loop=1, nPlot
         read(11, *) 
     &   Ix, Jy, Kz,
     &   Xarray(loop), Yarray(loop), Zarray(loop), Sarray(loop),
     &   Uarray(loop), Varray(loop), Warray(loop), Tarray(loop)
      end do
      close(11)

      return
      end subroutine


!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine Project2D(             ! 2D projection
     &     nFlag, nPlot, 
     &     Xarray, Yarray, Zarray, Sarray,
     &     Uarray, Varray, Warray, Tarray, md1)
!!--
      integer  nPlot                    ! number of plot points
      real*4   Xarray(md1)              ! array of X
      real*4   Yarray(md1)              ! array of Y
      real*4   Zarray(md1)              ! array of Z
      real*4   Sarray(md1)              ! array of Scalar
      real*4   Uarray(md1)              ! array of U
      real*4   Varray(md1)              ! array of V
      real*4   Warray(md1)              ! array of W
      real*4   Tarray(md1)              ! array of Z
!!--
      integer  nFlag                    ! projection flag
                                        !  1: I, 2: J, 3: K
!!--
      real*4   aveXYZ                   ! 
!!--
!!---
      write(*,*) "sub : Project2D"
!!---
      if( nFlag == 1)then
         aveXYZ=0.0
         do loop=1, nPlot
            aveXYZ=aveXYZ+Xarray(loop)
         end do
         aveXYZ=aveXYZ/float(nPlot)
         do loop=1, nPlot
            Xarray(loop)=aveXYZ
         end do
      else if( nFlag == 2)then
         aveXYZ=0.0
         do loop=1, nPlot
            aveXYZ=aveXYZ+Yarray(loop)
         end do
         aveXYZ=aveXYZ/float(nPlot)
         do loop=1, nPlot
            Yarray(loop)=aveXYZ
         end do
      else if( nFlag == 3)then
         aveXYZ=0.0
         do loop=1, nPlot
            aveXYZ=aveXYZ+Zarray(loop)
         end do
         aveXYZ=aveXYZ/float(nPlot)
         do loop=1, nPlot
            Zarray(loop)=aveXYZ
         end do
      end if


      return
      end subroutine



!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine ReadPatchData(         ! read patch data
     &     FileInput, nPatch, nRectangle, md2)

      character(len=*) FileInput        ! input Export file
      integer  nPatch                   ! number of patches
      integer  nRectangle(md2,5)        ! vertex list
                                        ! 1-4 ... base triangle
                                        ! 5   ... crest node
      character(len=100) charLine       ! one-line character variable
      integer nVert(0:10)               ! vertex list

!!---
      write(*,*) "sub : ReadPatchData"
!!---
      open(11, file=FileInput, status="old")
      do loop=1, 1
         read(11,"(a)") charCheck       ! skip header
         write(*,*) charCheck
      end do
      read(11,*) nPlot
      read(11,*)                        ! skip header
      do loop=1, nPlot
         read(11, *) 
      end do
      read(11,*)                        ! skip "GEOMETRY"
!!---
      read(11,*) nPatch
      write(*,*) "nPatch", nPatch
      do loop=1, nPatch
         read(11,"(a)") charLine

         if(charLine(1:1) == "4" .and.
     &      charLine(2:2) == " " )then

            read(charLine,*) (nVert(i),i=0, 4)
            do ii=1, 4
               nRectangle(loop, ii)=nVert(ii)
            end do
         else
            write(*,*)"contained intended patches"
         end if

      end do
      close(11)

      return
      end subroutine




!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine OutputFVUNS(          ! output FV-UNS file
     &     FileOutput,
     &     nPlot, Xarray, Yarray, Zarray, Sarray,
     &            Uarray, Varray, Warray, Tarray,
     &     nPatch, nRectangle, md1, md2)
!!---
      character(len=*) FileOutput       ! output FV-UNS file
!!---
      integer  nPlot                    ! number of plot points
      real*4   Xarray(md1)              ! array of X
      real*4   Yarray(md1)              ! array of Y
      real*4   Zarray(md1)              ! array of Z
      real*4   Sarray(md1)              ! array of Scalar
      real*4   Uarray(md1)              ! array of U
      real*4   Varray(md1)              ! array of V
      real*4   Warray(md1)              ! array of W
      real*4   Tarray(md1)              ! array of Z
!!---
      integer  nPatch                   ! number of patches
      integer  nRectangle(md2,5)        ! vertex list
                                        ! 1-4 ... base triangle
                                        ! 5   ... crest node
!!---
      open(31, file=FileOutput, status="unknown")
      write(31,"(a13)") 'FIELDVIEW 3 0'
      write(31, "(a9)") 'Constants'
      write(31, *) 1., 0., 0., 0.
      ngrids = 1
      write(31, "(a5, i10)") 'Grids', ngrids
      write(31, "(a14,i10)") 'Boundary Table', 1
      write(31, *) 0, 1, 1, ' ', 'surface_for_normal'
      nvars = 5
      write(31, "(a14, i10)") 'Variable Names', nvars
      write(31, *) 'scalar'
      write(31, *) 'uvel; velocity'
      write(31, *) 'vvel'
      write(31, *) 'wvel'
      write(31, *) 'threshold'
      nbvars = 5
      write(31, "(a23, i10)") 'Boundary Variable Names', nbvars
      write(31, *) 'scalar'
      write(31, *) 'uvel; velocity'
      write(31, *) 'vvel'
      write(31, *) 'wvel'
      write(31, *) 'threshold'
!!---
      write(31, "(a5, i10)") 'Nodes', nPlot
      do loop=1, nPlot
         write(31, "(3(1x, e15.5))")
     &   Xarray(loop), Yarray(loop), Zarray(loop)
      end do
!!---
      write(31, "(a14, i10)") 'Boundary Faces', nPatch
      do loop=1, nPatch
         write(31, *) 1, 4, (nRectangle(loop,ii),ii=1, 4)
      end do

!!---
      write(31, "(a8)") 'Elements'
      do loop=1, nPatch
         write(31, *) 2, 1
         write(31, *) (nRectangle(loop, ii),ii=1, 4),
     &                (nRectangle(loop, ii),ii=1, 4)
      end do

!!---
      write(31, "(a9)") 'Variables'
!!---                                   ! for scalar
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Sarray(loop)
      end do
!!---                                   ! for U-vel
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Uarray(loop)
      end do
!!---                                   ! for V-vel
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Varray(loop)
      end do
!!---                                   ! for W-vel
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Warray(loop)
      end do
!!---                                   ! for T-vel
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      do loop=1, nPlot               ! for every vertex
         write(31,"(1x,e15.5)") Tarray(loop)
!!         write(31,"(1x,e15.5)") 0.0
      end do
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

      write(31, "(a18)") 'Boundary Variables'
      do loop=1, nPatch                 ! for every boundary face
         write(31,"(1x,e15.5)")
     &   0.25*( Sarray(nRectangle(loop,1))
     &         +Sarray(nRectangle(loop,2))
     &         +Sarray(nRectangle(loop,3))
     &         +Sarray(nRectangle(loop,4)))
      end do
      do loop=1, nPatch                 ! for every boundary face
         write(31,"(1x,e15.5)")
     &   0.25*( Uarray(nRectangle(loop,1))
     &         +Uarray(nRectangle(loop,2))
     &         +Uarray(nRectangle(loop,3))
     &         +Uarray(nRectangle(loop,4)))
      end do
      do loop=1, nPatch                 ! for every boundary face
         write(31,"(1x,e15.5)")
     &   0.25*( Varray(nRectangle(loop,1))
     &         +Varray(nRectangle(loop,2))
     &         +Varray(nRectangle(loop,3))
     &         +Varray(nRectangle(loop,4)))
      end do
      do loop=1, nPatch                 ! for every boundary face
         write(31,"(1x,e15.5)")
     &   0.25*( Warray(nRectangle(loop,1))
     &         +Warray(nRectangle(loop,2))
     &         +Warray(nRectangle(loop,3))
     &         +Warray(nRectangle(loop,4)))
      end do
      do loop=1, nPatch                 ! for every boundary face
         write(31,"(1x,e15.5)")
     &   0.25*( Tarray(nRectangle(loop,1))
     &         +Tarray(nRectangle(loop,2))
     &         +Tarray(nRectangle(loop,3))
     &         +Tarray(nRectangle(loop,4)))
      end do



      close(31)

      return
      end subroutine
