#!/bin/bash

### I/O configuration ###
inputfile="./measured.dat"
#inputfile="./AllExportData.dat"
outputfile="./output.uns"

### banner ###
echo "--------------"
echo "---- M2F.sh --"
echo "--------------"


### pre-process for delaunay triangulation ###
nRow=`wc -l ${inputfile} | awk '(NR==1){printf("%d", $1-1)}' `
echo "number of plots" ${nRow}

rm -f "./plot.tmp"
echo "3" > "./plot.tmp"
echo ${nRow} >> "./plot.tmp"
awk '(NR > 1){printf(" %f %f %f\n", $1, $2, $3)}' ${inputfile} >> "./plot.tmp"

qdelaunay Qt s i < "./plot.tmp" > "./delaunay.tmp"

### create control file ###
ctrlfile="./Measured2FVUNS.ctl"
echo "###### Measured2FVUNS.ctl #####" > ${ctrlfile}
echo ${inputfile} >>  ${ctrlfile}
echo ${outputfile} >>  ${ctrlfile}
echo "./delaunay.tmp" >>  ${ctrlfile}


### converter running ###
g77 -O2 -Wall -mno-cygwin -o Measured2FVUNS Measured2FVUNS.f
./Measured2FVUNS
rm -f ./Measured2FVUNS.exe

