!!-----------------------------------------------------------------------
!!--
!!-- Copyright (c) 2010 VINAS
!!-- All rights reserved.
!!--
!!-- This sample fortran script is not supported
!!--                                by VINAS and VINAS provides
!!-- no warranties or assurances about its fitness or merchantability.
!!-- It is provided at no cost and is for demonstration purposes only.
!!--
!!--
!!--                                          Measured2FVUNS.f
!!--
!!--                                          T.Y.   Fri. June 18, 2010 
!!--
!!----------------------------------------------------------------------

!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      program Measured2FVUNS            ! 

      parameter(md1=1071155, md2=100385)
!!---
      character(len=256) FileInput      ! input Export file
      character(len=256) FileOutput     ! output FV-UNS file
      character(len=256) FileDelaunay   ! control file for delaunay
!!---
      integer  nPlot                    ! number of plot points
      integer  nPatch                   ! number of patches
!!---
      integer  nFlag                    ! projection flag
                                        !  1: I, 2: J, 3: K
!!---
      real*4   Xarray(md1)              ! array of X
      real*4   Yarray(md1)              ! array of Y
      real*4   Zarray(md1)              ! array of Z
      real*4   Sarray(md1)              ! array of Scalar
      real*4   Uarray(md1)              ! array of U
      real*4   Varray(md1)              ! array of V
      real*4   Warray(md1)              ! array of W
      real*4   Tarray(md1)              ! array of Z
!!---
      integer  nTets(md2,4)             ! vertex list
                                        ! 1-3 ... base triangle
                                        ! 4   ... crest node

!!---
!!---
      call ReadCtrlFile(                ! read control file
     &     nPlot, FileInput, FileOutput, FileDelaunay)

      call ReadVertexData(              ! read vertex data
     &     FileInput, nPlot,
     &     Xarray, Yarray, Zarray, Sarray,
     &     Uarray, Varray, Warray, Tarray, md1)

      call ReadPatchData(               ! read patch data
     &     FileDelaunay, nPatch, nTets, md2)

      call OutputFVUNS(                ! output FV-UNS file
     &     FileOutput,
     &     nPlot, Xarray, Yarray, Zarray, Sarray,
     &            Uarray, Varray, Warray, Tarray,
     &     nPatch, nTets, md1, md2)



      stop
      end program


!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine ReadCtrlFile(          ! control file の読み込み
     &     nPlot, FileInput, FileOutput, FileDelaunay)

      character(len=*) FileInput        ! input Export file
      character(len=*) FileOutput       ! output FV-UNS file
      character(len=*) FileDelaunay     ! control file for delaunay
!!---
      integer  nPlot                    ! number of plot points
!!---
!!---
      write(*,*) "sub : ReadCtrlFile"
!!---
      open(99,file='./Measured2FVUNS.ctl',status='old')

      read(99,*)                        ! read through
      read(99,'(a)') FileInput
      read(99,'(a)') FileOutput
      read(99,'(a)') FileDelaunay
      close(99)
!!---
      open(11,file=FileInput,status='old')
      nPlot=0
      read(11, *)                       ! skip header
      do
      read(11, *, iostat=intEOF) xyz
         if(intEOF /= 0)then
            exit
         else
            nPlot=nPlot+1
         end if
      end do
      close(11)
!!---
      write(*,*)           '-------------------------------------------'
      write(*,*)           '-----        Measured2FVUNS.f      --------'
      write(*,*)           '-------------------------------------------'
      write(*,"(a23,a40)") '    input Export file :',FileInput
      write(*,"(a23,a40)") '   output FV-UNS file :',FileOutput
      write(*,"(a23,a40)") 'control delaunay file :',FileDelaunay
      write(*,"(a23,i10)") '     number  of plots :',nPlot
      write(*,*)           '--------------------'
      write(*,*)           ''

      return
      end subroutine



!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine ReadVertexData(        ! read vertex data
     &     FileInput, nPlot,
     &     Xarray, Yarray, Zarray, Sarray,
     &     Uarray, Varray, Warray, Tarray, md1)

      character(len=*) FileInput        ! input Export file
      integer  nPlot                    ! number of plot points
      real*4   Xarray(md1)              ! array of X
      real*4   Yarray(md1)              ! array of Y
      real*4   Zarray(md1)              ! array of Z
      real*4   Sarray(md1)              ! array of Scalar
      real*4   Uarray(md1)              ! array of U
      real*4   Varray(md1)              ! array of V
      real*4   Warray(md1)              ! array of W
      real*4   Tarray(md1)              ! array of Z

      character(len=50) charCheck

!!---
      write(*,*) "sub : ReadVertexData"
!!---
      do loop=1, md1
         Xarray(loop)=0.0
         Yarray(loop)=0.0
         Zarray(loop)=0.0
         Sarray(loop)=0.0
         Uarray(loop)=0.0
         Varray(loop)=0.0
         Warray(loop)=0.0
         Tarray(loop)=0.0
      end do
!!---
      open(11, file=FileInput, status="old")
      read(11,*)                        ! skip header
      write(*,*) "nPlot:", nPlot
      do loop=1, nPlot
         read(11, *) 
     &   Xarray(loop), Yarray(loop), Zarray(loop), Sarray(loop),
     &   Uarray(loop), Varray(loop), Warray(loop), Tarray(loop)
      end do
      close(11)

      return
      end subroutine


!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine ReadPatchData(         ! read patch data
     &     FileDelaunay, nPatch, nTets, md2)

      character(len=*) FileDelaunay     ! control file for delaunay
      integer  nPatch                   ! number of patches
!!---
      integer  nTets(md2,4)             ! vertex list
                                        ! 1-3 ... base triangle
                                        ! 4   ... crest node

      character(len=100) charLine       ! one-line character variable
      integer nVert(0:10)               ! vertex list



!!---
      write(*,*) "sub : ReadPatchData"
!!---
      open(11, file=FileDelaunay, status="old")
      read(11,*) nPatch
      write(*,*) "nPatch", nPatch
      do loop=1, nPatch
         read(11,*) (nVert(i),i=1, 4)
         do ii=1, 4
            nTets(loop, ii)=nVert(ii)+1
                                        ! because 
                                        ! node number start from "0"
                                        !  with qdelaunay output
         end do
      end do
      close(11)

      return
      end subroutine



!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine OutputFVUNS(          ! output FV-UNS file
     &     FileOutput,
     &     nPlot, Xarray, Yarray, Zarray, Sarray,
     &            Uarray, Varray, Warray, Tarray,
     &     nPatch, nTets, md1, md2)
!!---
      character(len=*) FileOutput       ! output FV-UNS file
!!---
      integer  nPlot                    ! number of plot points
      real*4   Xarray(md1)              ! array of X
      real*4   Yarray(md1)              ! array of Y
      real*4   Zarray(md1)              ! array of Z
      real*4   Sarray(md1)              ! array of Scalar
      real*4   Uarray(md1)              ! array of U
      real*4   Varray(md1)              ! array of V
      real*4   Warray(md1)              ! array of W
      real*4   Tarray(md1)              ! array of Z
!!---
      integer  nPatch                   ! number of patches
!!---
      integer  nTets(md2,4)             ! vertex list
                                        ! 1-3 ... base triangle
                                        ! 4   ... crest node
!!---
      open(31, file=FileOutput, status="unknown")
      write(31,"(a13)") 'FIELDVIEW 3 0'
      write(31, "(a9)") 'Constants'
      write(31, *) 1., 0., 0., 0.
      ngrids = 1
      write(31, "(a5, i10)") 'Grids', ngrids
      write(31, "(a14,i10)") 'Boundary Table', 1
      write(31, *) 0, 1, 1, ' ', 'surface_for_normal'
      nvars = 5
      write(31, "(a14, i10)") 'Variable Names', nvars
      write(31, *) 'scalar'
      write(31, *) 'uvel; velocity'
      write(31, *) 'vvel'
      write(31, *) 'wvel'
      write(31, *) 'threshold'
      nbvars = 5
      write(31, "(a23, i10)") 'Boundary Variable Names', 0
!      write(31, "(a23, i10)") 'Boundary Variable Names', nbvars
!      write(31, *) 'scalar'
!      write(31, *) 'uvel; velocity'
!      write(31, *) 'vvel'
!      write(31, *) 'wvel'
!      write(31, *) 'threshold'
!!---
      write(31, "(a5, i10)") 'Nodes', nPlot
      do loop=1, nPlot
         write(31, "(3(1x, e15.5))")
     &   Xarray(loop), Yarray(loop), Zarray(loop)
      end do
!!---
      write(31, "(a14, i10)") 'Boundary Faces', 0
!      write(31, "(a14, i10)") 'Boundary Faces', nPatch
!      do loop=1, nPatch
!         write(31, *) 1, 4, (nTets(loop,ii),ii=1, 4)
!      end do

!!---
      write(31, "(a8)") 'Elements'
      do loop=1, nPatch
         write(31, *) 1, 1
         write(31, *) (nTets(loop, ii),ii=1, 4)
      end do

!!---
      write(31, "(a9)") 'Variables'
!!---                                   ! for scalar
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Sarray(loop)
      end do
!!---                                   ! for U-vel
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Uarray(loop)
      end do
!!---                                   ! for V-vel
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Varray(loop)
      end do
!!---                                   ! for W-vel
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Warray(loop)
      end do
!!---                                   ! for T-vel
      do loop=1, nPlot               ! for every vertex
         write(31,"(1x,e15.5)") Tarray(loop)
      end do




      close(31)

      return
      end subroutine
