!!-----------------------------------------------------------------------
!!--
!!-- Copyright (c) 201 VINAS
!!-- All rights reserved.
!!--
!!-- This sample fortran script is not supported
!!--                                by VINAS and VINAS provides
!!-- no warranties or assurances about its fitness or merchantability.
!!-- It is provided at no cost and is for demonstration purposes only.
!!--
!!--
!!--                                                createMathDistrib.f
!!--
!!--                                     T.Yoshida   Wed. Mar. 09, 2011 
!!--
!!----------------------------------------------------------------------

      program makeMathDatabase

      parameter(md1=500, md2=500, md3=500)
      integer nx, ny
      real*4  xc(md1), yc(md2), zc(md3)

      real*4  xx(0:md1), yy(0:md2), zz(0:md3)
      real*4  Grid(0:md1, 0:md2)

      real*4  pi
      real*4   S(md1,md2)

!!---
      pi=4.0*atan(1.0)
      write(*,*) "pi:", pi

!!---
      nx=200
      ny=200
      nz=2

      Xinit=0.0
      Xterm=100.0  ! 2.0*pi

      Yinit=0.0
      Yterm=100.0  ! 2.0*pi

      Zinit=0.0
      Zterm=50.0  ! 2.0*pi

!!---
      write(*,*) "xx( ):"
      xx(0)=0.0
      do i=1, nx
         xx(i)=xx(i-1)+ ((Xterm - Xinit)/float(nx))
      end do

!!---
      write(*,*) "yy( ):"
      yy(0)=0.0
      do j=1, ny
         yy(j)=yy(j-1)+ ((Yterm - Yinit)/float(ny))
      end do

!!---
      write(*,*) "zz( ):"
      zz(0)=0.0
      do k=1, nz
         zz(k)=zz(k-1)+ ((Zterm - Zinit)/float(nz))
      end do


!!---
      do j=0, ny
         do i=0, nx
            Grid(i,j)=3.0+(sin(0.5*xx(i)))*(sin(0.5*yy(j)))
           ! Grid(i,j)=3.0+(sin(0.5*xx(i)))*(sin(0.5*yy(j)))
           ! Grid(i,j)=(sin(xx(i)))*(sin(yy(j)))
           ! if(Grid(i, j) < 0.0)then
           !    Grid(i,j)=0.0
           ! end if
         end do
      end do



!!---

      open(24, file="./sample2d.grd", status="unknown")
      write(24,*) 1
      write(24,*) nx+1, ny+1, 1
      write(24, "(4(1x,f12.4))") ((xx(i), i=0, nx), j=0, ny)
      write(24, "(4(1x,f12.4))") ((yy(j), i=0, nx), j=0, ny)
      write(24, "(4(1x,f12.4))")
     &  (((Grid(i,j), i=0, nx), j=0, ny), k=1, nz)
      close(24)

      stop
      end program
