!!-----------------------------------------------------------------------
!!--
!!-- Copyright (c) 2011 VINAS
!!-- All rights reserved.
!!--
!!-- This sample fortran script is not supported
!!--                                by VINAS and VINAS provides
!!-- no warranties or assurances about its fitness or merchantability.
!!-- It is provided at no cost and is for demonstration purposes only.
!!--
!!--
!!--                                             Coordinate2FVUNS.f
!!--
!!--                                          T.Y.   Thu. Sept. 1, 2011 
!!--
!!----------------------------------------------------------------------

!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      program Coordinate2FVUNS          ! 

      parameter(md1=1071155, md2=100385)
!!---
      character(len=256) FileInput      ! input Export file
      character(len=256) FileOutput     ! output FV-UNS file
!!---
      integer  nPlot                    ! number of plot points
      integer  nPatch                   ! number of patches
!!---
      character(len=100) charLine       ! one-line character variable
      integer nVert(0:10)               ! vertex list
!!---
      real*4  Xp(3), Yp(3), Zp(3)       ! vertex of triangle 
      real*4  Scalar(3), Threshold(3)   ! 
      real*4  U(3), V(3), W(3)          ! 
!!---
      real*4   Xcr,   Ycr,   Zcr        ! position of crest vertex
      real*4   Scr,   Tcr               ! Scalar,threshold at crest vertex
      real*4   Ucr,   Vcr,   Wcr        ! u,v,w of  crest vertex
!!---
      real*4   Xnorm, Ynorm, Znorm      ! normal vector
!!---
      real*4   Xarray(md1)              ! array of X
      real*4   Yarray(md1)              ! array of Y
      real*4   Zarray(md1)              ! array of Z
      real*4   Sarray(md1)              ! array of Scalar
      real*4   Uarray(md1)              ! array of U
      real*4   Varray(md1)              ! array of V
      real*4   Warray(md1)              ! array of W
      real*4   Tarray(md1)              ! array of Z
!!---
      integer  nTriangle(md2,4)         ! vertex list
                                        ! 1-3 ... base triangle
                                        ! 4   ... crest node
!!---
      real*4   XnrmArray(md2)           ! array of Xnorm
      real*4   YnrmArray(md2)           ! array of Ynorm
      real*4   ZnrmArray(md2)           ! array of Znorm

      real*4   ScFacArray(md2)          ! array of Scalar at Face
      real*4   ThFacArray(md2)          ! array of Threshold at Face

!!---

      call ReadCtrlFile(                ! read control file
     &     FileInput, FileOutput)

      call ReadPlotData(                ! read plot data
     &     FileInput, nPlot,
     &     Xarray, Yarray, Zarray, Sarray,
     &     Uarray, Varray, Warray, Tarray, md1)

      call ReadPatchData(               ! read patch data
     &     FileInput, nPatch, nTriangle, md2)

      write(*,*) "---- start loop : for patch creation ----"
      nFace=nPatch
      nP=nPlot
      do loop=1, nPatch
         do ii=1, 3                     ! for every vertex
            Xp(ii)=Xarray(nTriangle(loop, ii))
            Yp(ii)=Yarray(nTriangle(loop, ii))
            Zp(ii)=Zarray(nTriangle(loop, ii))
         end do

         call CreateNormal(            ! normal vector detection
     &   Xnorm, Ynorm, Znorm, Xp, Yp, Zp)

         call CreateCrestVertex(       ! detect crest vertex position
     &   Xnorm, Ynorm, Znorm, Xp, Yp, Zp, Xcr, Ycr, Zcr)

         call CreateCrestVariables(    ! create each variable at crest
     &   Xp,  Yp,  Zp,  Scalar, Threshold, U,   V,   W,
     &   Xcr, Ycr, Zcr, Scr,    Tcr,       Ucr, Vcr, Wcr)

         ScFacArray(loop)=Scr
         ThFacArray(loop)=Tcr

         XnrmArray(loop)=Xnorm*Scr
         YnrmArray(loop)=Ynorm*Scr
         ZnrmArray(loop)=Znorm*Scr
         !! XnrmArray(loop)=Xnorm
         !! YnrmArray(loop)=Ynorm
         !! ZnrmArray(loop)=Znorm


         nP=nP+1                       ! count up for new list

         call AddNodeList(             ! 
     &        nP, Xarray, Yarray, Zarray, Sarray,
     &            Uarray, Varray, Warray, Tarray,
     &            Xcr, Ycr, Zcr, Scr, Ucr, Vcr, Wcr, Tcr, md1)

         nTriangle(loop, 4)=nP
         !!!nFace=nFace+3              ! add except base triangle
      end do

      write(*,*)"nPlot: ",nPlot, "---> nP", nP
      nPlot=nP
      !!! nPatch=nFace

      write(*,*) "----   end loop : for patch creation ----"


      call OutputFVUNS(                ! output FV-UNS file
     &     FileOutput,
     &     nPlot, Xarray, Yarray, Zarray, Sarray,
     &            Uarray, Varray, Warray, Tarray,
     &           XnrmArray, YnrmArray, ZnrmArray,
     &                    ScFacArray, ThFacArray,
     &     nPatch, nTriangle, md1, md2)




      stop
      end program


!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine ReadCtrlFile(          ! control file の読み込み
     &     FileInput, FileOutput)

      character(len=*) FileInput        ! input Export file
      character(len=*) FileOutput       ! output FV-UNS file

!!---
      write(*,*) "sub : ReadCtrlFile"
!!---
      open(99,file='./Coordinate2FVUNS.ctl',status='old')

      read(99,*)                        ! read through
      read(99,'(a)') FileInput
      read(99,'(a)') FileOutput
      close(99)

      write(*,*)           '-------------------------------------------'
      write(*,*)           '-----      Coordinate2FVUNS.f      --------'
      write(*,*)           '-------------------------------------------'
      write(*,"(a20,a40)") ' input Export file :',FileInput
      write(*,"(a20,a40)") 'output FV-UNS file :',FileOutput
      write(*,*)           '--------------------'
      write(*,*)           ''

      return
      end subroutine

!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine ReadPlotData(          ! read plot data
     &     FileInput, nPlot,
     &     Xarray, Yarray, Zarray, Sarray,
     &     Uarray, Varray, Warray, Tarray, md1)

      character(len=*) FileInput        ! input Export file
      integer  nPlot                    ! number of plot points
      real*4   Xarray(md1)              ! array of X
      real*4   Yarray(md1)              ! array of Y
      real*4   Zarray(md1)              ! array of Z
      real*4   Sarray(md1)              ! array of Scalar
      real*4   Uarray(md1)              ! array of U
      real*4   Varray(md1)              ! array of V
      real*4   Warray(md1)              ! array of W
      real*4   Tarray(md1)              ! array of Z

      character(len=50) charCheck

!!---
      write(*,*) "sub : ReadPlotData"
!!---
      do loop=1, md1
         Xarray(loop)=0.0
         Yarray(loop)=0.0
         Zarray(loop)=0.0
         Sarray(loop)=0.0
         Uarray(loop)=0.0
         Varray(loop)=0.0
         Warray(loop)=0.0
         Tarray(loop)=0.0
      end do
!!---
      open(11, file=FileInput, status="old")
      do loop=1, 1
         read(11,"(a)") charCheck       ! skip header
         write(*,*) charCheck
      end do
      read(11,*) nPlot
      write(*,*) "nPlot:", nPlot
      read(11,*)                        ! skip header
      do loop=1, nPlot
         read(11, *) 
     &   Xarray(loop), Yarray(loop), Zarray(loop), Sarray(loop),
     &   Uarray(loop), Varray(loop), Warray(loop), Tarray(loop)
      end do
      close(11)

      return
      end subroutine


!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine ReadPatchData(         ! read patch data
     &     FileInput, nPatch, nTriangle, md2)

      character(len=*) FileInput        ! input Export file
      integer  nPatch                   ! number of patches
      integer  nTriangle(md2,3)         ! vertex list
      character(len=100) charLine       ! one-line character variable
      integer nVert(0:10)               ! vertex list

!!---
      write(*,*) "sub : ReadPatchData"
!!---
      open(11, file=FileInput, status="old")
      do loop=1, 1
         read(11,"(a)") charCheck       ! skip header
         write(*,*) charCheck
      end do
      read(11,*) nPlot
      read(11,*)                        ! skip header
      do loop=1, nPlot
         read(11, *) 
      end do
      read(11,*)                        ! skip "GEOMETRY"
!!---
      read(11,*) nPatch
      write(*,*) "nPatch", nPatch
      nCount=0
      do loop=1, nPatch
         read(11,"(a)") charLine

         nCount=nCount+1

         if(charLine(1:1) == "3" .and.
     &      charLine(2:2) == " " )then
            read(charLine,*) (nVert(i),i=0, 3)
            do ii=1, 3
               nTriangle(nCount, ii)=nVert(ii)
            end do
         else if(charLine(1:1) == "4" .and.
     &      charLine(2:2) == " " )then
            read(charLine,*) (nVert(i),i=0, 4)

            do ii=1, 3
               nTriangle(nCount, ii)=nVert(ii)
            end do

            nCount=nCount+1
            nTriangle(nCount, 1)=nVert(1)
            nTriangle(nCount, 2)=nVert(3)
            nTriangle(nCount, 3)=nVert(4)

         else if(charLine(1:1) == "5" .and.
     &      charLine(2:2) == " " )then
            read(charLine,*) (nVert(i),i=0, 5)

            do ii=1, 3
               nTriangle(nCount, ii)=nVert(ii)
            end do

            nCount=nCount+1
            nTriangle(nCount, 1)=nVert(1)
            nTriangle(nCount, 2)=nVert(3)
            nTriangle(nCount, 3)=nVert(4)

            nCount=nCount+1
            nTriangle(nCount, 1)=nVert(1)
            nTriangle(nCount, 2)=nVert(4)
            nTriangle(nCount, 3)=nVert(5)

         end if
      end do
      nPatch=nCount
      write(*,*) "---> nPatch", nPatch
      close(11)


      return
      end subroutine


!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
       subroutine CreateNormal(         ! create normal vector
     &          Xnorm, Ynorm, Znorm, Xp, Yp, Zp)

      real*4   Xnorm, Ynorm, Znorm      ! normal vector
      real*4  Xp(3), Yp(3), Zp(3)       ! vertex of triangle 

      real*4   x1, y1, z1               ! 第１ベクトル成分
      real*4   x2, y2, z2               ! 第２ベクトル成分

      real*4   Dist                     ! ベクトル絶対値

      real*4   zero                     ! threshold 
!!---
      zero=1.0e-7

!!---
      x1=Xp(3)-Xp(2)
      y1=Yp(3)-Yp(2)
      z1=Zp(3)-Zp(2)

      x2=Xp(1)-Xp(2)
      y2=Yp(1)-Yp(2)
      z2=Zp(1)-Zp(2)
!!---                                   ! outer product
      Xnorm=y1*z2-y2*z1
      Ynorm=z1*x2-z2*x1
      Znorm=x1*y2-x2*y1

!!---
      Dist=(Xnorm**2.0)+(Ynorm**2.0)+(Znorm**2.0)
      Dist=sqrt(Dist)


      if(Dist > zero)then
         Xnorm=Xnorm/Dist
         Ynorm=Ynorm/Dist
         Znorm=Znorm/Dist
      else
         Xnorm=0.0
         Ynorm=0.0
         Znorm=0.0
      end if

      return
      end subroutine


!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine CreateCrestVertex(  ! detect crest vertex position
     &   Xnorm, Ynorm, Znorm, Xp, Yp, Zp, Xcr, Ycr, Zcr)

      real*4   Xnorm, Ynorm, Znorm      ! normal vector
      real*4  Xp(3), Yp(3), Zp(3)       ! vertex of triangle 
      real*4   Xcr,   Ycr,   Zcr        ! position of crest vertex
!!---
      real*4   Xgr,   Ygr,   Zgr        ! gravity point of triangle
      real*4   rLength(0:3)             ! length of each side
!!---
      real*4    dX,   dY,   dZ          ! displacement 

!!---                                   ! gravity point detection
      Xgr=0.0
      Ygr=0.0
      Zgr=0.0
      do loop=1, 3
         Xgr=Xgr+Xp(loop)
         Ygr=Ygr+Yp(loop)
         Zgr=Zgr+Zp(loop)
      end do
      Xgr=Xgr/float(3)
      Ygr=Ygr/float(3)
      Zgr=Zgr/float(3)

         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
         !! write(*,*)"---- now test trial -----"
         Xcr=Xgr
         Ycr=Ygr
         Zcr=Zgr
         return
         !! for surface creation with 
         !!    skewed volumes
         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!!---
      rLength(1)=sqrt( ((Xp(2)-Xp(1))**2.0)
     &                +((Yp(2)-Yp(1))**2.0)
     &                +((Zp(2)-Zp(1))**2.0) )

      rLength(2)=sqrt( ((Xp(3)-Xp(2))**2.0)
     &                +((Yp(3)-Yp(2))**2.0)
     &                +((Zp(3)-Zp(2))**2.0) )

      rLength(3)=sqrt( ((Xp(1)-Xp(3))**2.0)
     &                +((Yp(1)-Yp(3))**2.0)
     &                +((Zp(1)-Zp(3))**2.0) )

      rLength(0)=0.0
      do loop=1, 3
         rLength(0)=rLength(0)+rLength(loop)
      end do
      rLength(0)=rLength(0)/float(3)

!!---
      dX=rLength(0)*Xnorm
      dY=rLength(0)*Ynorm
      dZ=rLength(0)*Znorm
!!---
      Xcr=Xgr+dX
      Ycr=Ygr+dY
      Zcr=Zgr+dZ
!!---

      return
      end subroutine


!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine CreateCrestVariables( ! create each variable at crest
     &   Xp,  Yp,  Zp,  Scalar, Threshold, U,   V,   W,
     &   Xcr, Ycr, Zcr, Scr,    Tcr,       Ucr, Vcr, Wcr)
!!---
      real*4  Xp(3), Yp(3), Zp(3)       ! vertex of triangle 
      real*4  Scalar(3), Threshold(3)   ! 
      real*4  U(3), V(3), W(3)          ! 
!!---
      real*4   Xcr,   Ycr,   Zcr        ! position of crest vertex
      real*4   Scr,   Tcr               ! Scalar,threshold at crest vertex
      real*4   Ucr,   Vcr,   Wcr        ! u,v,w of  crest vertex
!!---
      Scr=0.0
      Tcr=0.0
      Ucr=0.0
      Vcr=0.0
      Wcr=0.0
!!---
      do loop=1, 3
         Scr=Scr+Scalar(loop)
         Tcr=Tcr+Threshold(loop)
         Ucr=Ucr+U(loop)
         Vcr=Vcr+V(loop)
         Wcr=Wcr+W(loop)
      end do
!!---
      Scr=Scr/float(3)
      Tcr=Tcr/float(3)
      Ucr=Ucr/float(3)
      Vcr=Vcr/float(3)
      Wcr=Wcr/float(3)
!!---

      return
      end subroutine


!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine AddNodeList(   !
     &        nP, Xarray, Yarray, Zarray, Sarray,
     &            Uarray, Varray, Warray, Tarray,
     &            Xcr, Ycr, Zcr, Scr, Ucr, Vcr, Wcr, Tcr, md1)

!!---
      real*4   Xarray(md1)              ! array of X
      real*4   Yarray(md1)              ! array of Y
      real*4   Zarray(md1)              ! array of Z
      real*4   Sarray(md1)              ! array of Scalar
      real*4   Uarray(md1)              ! array of U
      real*4   Varray(md1)              ! array of V
      real*4   Warray(md1)              ! array of W
      real*4   Tarray(md1)              ! array of Z
!!---
      real*4   Xcr,   Ycr,   Zcr        ! position of crest vertex
      real*4   Scr,   Tcr               ! Scalar,threshold at crest vertex
      real*4   Ucr,   Vcr,   Wcr        ! u,v,w of  crest vertex
!!---
      integer  nP                       ! list number for addition
!!---
      if(np > md1)then
         write(*,*)"error: md1 is too small"
         write(*,*)" sub : AddNodeList"
         stop
      end if
!!---
      !!write(*,*)"now adding: (nP) ", nP
!!---
      Xarray(nP)=Xcr
      Yarray(nP)=Ycr
      Zarray(nP)=Zcr
      Sarray(nP)=Scr
      Tarray(nP)=Tcr
      Uarray(nP)=Ucr
      Varray(nP)=Vcr
      Warray(nP)=Wcr
!!---

      return
      end subroutine

!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine oldOutputFVUNS(          ! output FV-UNS file
     &     FileOutput,
     &     nPlot, Xarray, Yarray, Zarray, Sarray,
     &            Uarray, Varray, Warray, Tarray,
     &     nPatch, nTriangle, md1, md2)

      character(len=*) FileOutput       ! Output FV-UNS file
      integer  nPlot                    ! number of plot points
      integer  nPatch                   ! number of patches
!!---
      real*4   Xnorm, Ynorm, Znorm      ! normal vector
!!---
      real*4   Xarray(md1)              ! array of X
      real*4   Yarray(md1)              ! array of Y
      real*4   Zarray(md1)              ! array of Z
      real*4   Sarray(md1)              ! array of Scalar
      real*4   Uarray(md1)              ! array of U
      real*4   Varray(md1)              ! array of V
      real*4   Warray(md1)              ! array of W
      real*4   Tarray(md1)              ! array of Z
!!---
      integer  nTriangle(md2,4)         ! vertex list
                                        ! 1-3 ... base triangle
                                        ! 4   ... crest node


            write(*,*)"nPlot(sub outputFV-UNS)", nPlot
!!---
      open(31, file=FileOutput, status="unknown")
      write(31,"(a13)") 'FIELDVIEW 3 0'
      write(31, "(a9)") 'Constants'
      write(31, *) 1., 0., 0., 0.
      ngrids = 1
      write(31, "(a5, i10)") 'Grids', ngrids
      write(31, "(a14,i10)") 'Boundary Table', 1
      write(31, *) 0, 1, 1, ' ', 'surface_for_normal'
      nvars = 5
      write(31, "(a14, i10)") 'Variable Names', nvars
      write(31, *) 'scalar'
      write(31, *) 'uvel; velocity'
      write(31, *) 'vvel'
      write(31, *) 'wvel'
      write(31, *) 'threshold'
      nbvars = 5
      write(31, "(a23, i10)") 'Boundary Variable Names', nbvars
      write(31, *) 'scalar'
      write(31, *) 'uvel; velocity'
      write(31, *) 'vvel'
      write(31, *) 'wvel'
      write(31, *) 'threshold'
!!---
      write(31, "(a5, i10)") 'Nodes', nPlot
      do loop=1, nPlot
         write(31, "(3(1x, e15.5))")
     &   Xarray(loop), Yarray(loop), Zarray(loop)
      end do

!!---
      write(31, "(a14, i10)") 'Boundary Faces', nPatch*4
      do loop=1, nPatch
         write(31, *) 1, 3, (nTriangle(loop,ii),ii=1, 3)
         write(31, *)
     &   1, 3, nTriangle(loop,1),nTriangle(loop,2),nTriangle(loop,4)
         write(31, *)
     &   1, 3, nTriangle(loop,2),nTriangle(loop,3),nTriangle(loop,4)
         write(31, *)
     &   1, 3, nTriangle(loop,3),nTriangle(loop,1),nTriangle(loop,4)
      end do

!!---
      write(31, "(a8)") 'Elements'
      do loop=1, nPatch
         write(31, *) 1, 1
         write(31, *) (nTriangle(loop, ii),ii=1, 4)
      end do



!!---
      write(31, "(a9)") 'Variables'
!!---                                   ! for scalar
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Sarray(loop)
      end do
!!---                                   ! for U-vel
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Uarray(loop)
      end do
!!---                                   ! for V-vel
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Varray(loop)
      end do
!!---                                   ! for W-vel
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Warray(loop)
      end do
!!---                                   ! for T-vel
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
           do loop=1, nPlot
        write(74,*) Tarray(loop)
           end do
      do loop=1, nPlot                  ! for every vertex
!!         write(31,"(1x,e15.5)") Tarray(loop)
         write(31,"(1x,e15.5)") 0.0
      end do
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


      write(31, "(a18)") 'Boundary Variables'
      do loop=1, nPatch


      end do

      close(31)


      return
      end subroutine



!     /*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*
      subroutine OutputFVUNS(          ! output FV-UNS file
     &     FileOutput,
     &     nPlot, Xarray, Yarray, Zarray, Sarray,
     &            Uarray, Varray, Warray, Tarray,
     &           XnrmArray, YnrmArray, ZnrmArray,
     &                    ScFacArray, ThFacArray,
     &     nPatch, nTriangle, md1, md2)

      character(len=*) FileOutput       ! Output FV-UNS file
      integer  nPlot                    ! number of plot points
      integer  nPatch                   ! number of patches
!!---
      real*4   Xnorm, Ynorm, Znorm      ! normal vector
!!---
      real*4   Xarray(md1)              ! array of X
      real*4   Yarray(md1)              ! array of Y
      real*4   Zarray(md1)              ! array of Z
      real*4   Sarray(md1)              ! array of Scalar
      real*4   Uarray(md1)              ! array of U
      real*4   Varray(md1)              ! array of V
      real*4   Warray(md1)              ! array of W
      real*4   Tarray(md1)              ! array of Z
!!---
      integer  nTriangle(md2,4)         ! vertex list
                                        ! 1-3 ... base triangle
                                        ! 4   ... crest node
!!---
      real*4   XnrmArray(md2)           ! array of Xnorm
      real*4   YnrmArray(md2)           ! array of Ynorm
      real*4   ZnrmArray(md2)           ! array of Znorm

      real*4   ScFacArray(md2)          ! array of Scalar at Face
      real*4   ThFacArray(md2)          ! array of Threshold at Face
!!---
!!---
            write(*,*)"nPlot(sub outputFV-UNS)", nPlot
!!---
      open(31, file=FileOutput, status="unknown")
      write(31,"(a13)") 'FIELDVIEW 3 0'
      write(31, "(a9)") 'Constants'
      write(31, *) 1., 0., 0., 0.
      ngrids = 1
      write(31, "(a5, i10)") 'Grids', ngrids
      write(31, "(a14,i10)") 'Boundary Table', 1
      write(31, *) 0, 1, 1, ' ', 'surface_for_normal'
      nvars = 5
      write(31, "(a14, i10)") 'Variable Names', nvars
      write(31, *) 'scalar'
      write(31, *) 'uvel; velocity'
      write(31, *) 'vvel'
      write(31, *) 'wvel'
      write(31, *) 'threshold'
      nbvars = 5
      write(31, "(a23, i10)") 'Boundary Variable Names', nbvars
      write(31, *) 'scalar'
      write(31, *) 'uvel; velocity'
      write(31, *) 'vvel'
      write(31, *) 'wvel'
      write(31, *) 'threshold'
!!---
      write(31, "(a5, i10)") 'Nodes', nPlot
      do loop=1, nPlot
         write(31, "(3(1x, e15.5))")
     &   Xarray(loop), Yarray(loop), Zarray(loop)
      end do

!!---
      !! write(31, "(a14, i10)") 'Boundary Faces', nPatch*4
      write(31, "(a14, i10)") 'Boundary Faces', nPatch
      do loop=1, nPatch
         write(31, *) 1, 3, (nTriangle(loop,ii),ii=1, 3)
!!         write(31, *)
!!     &   1, 3, nTriangle(loop,1),nTriangle(loop,2),nTriangle(loop,4)
!!         write(31, *)
!!     &   1, 3, nTriangle(loop,2),nTriangle(loop,3),nTriangle(loop,4)
!!         write(31, *)
!!     &   1, 3, nTriangle(loop,3),nTriangle(loop,1),nTriangle(loop,4)
      end do

!!---
      write(31, "(a8)") 'Elements'
      do loop=1, nPatch
         write(31, *) 1, 1
         write(31, *) (nTriangle(loop, ii),ii=1, 3),nTriangle(loop, 1)
      end do

!!---
      write(31, "(a9)") 'Variables'
!!---                                   ! for scalar
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Sarray(loop)
      end do
!!---                                   ! for U-vel
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Uarray(loop)
      end do
!!---                                   ! for V-vel
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Varray(loop)
      end do
!!---                                   ! for W-vel
      do loop=1, nPlot                  ! for every vertex
         write(31,"(1x,e15.5)") Warray(loop)
      end do
!!---                                   ! for T-vel
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
           do loop=1, nPlot
              write(74,*) Tarray(loop)
           end do
      do loop=1, nPlot               ! for every vertex
!!         write(31,"(1x,e15.5)") Tarray(loop)
         write(31,"(1x,e15.5)") 0.0
      end do
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


      write(31, "(a18)") 'Boundary Variables'
      do loop=1, nPatch                 ! for every boundary face
         write(31,"(1x,e15.5)") ScFacArray(loop)
      end do
      do loop=1, nPatch                 ! for every boundary face
         write(31,"(1x,e15.5)") XnrmArray(loop)
      end do
      do loop=1, nPatch                 ! for every boundary face
         write(31,"(1x,e15.5)") YnrmArray(loop)
      end do
      do loop=1, nPatch                 ! for every boundary face
         write(31,"(1x,e15.5)") ZnrmArray(loop)
      end do
      do loop=1, nPatch                 ! for every boundary face
         !!write(31,"(1x,e15.5)") ThFacArray(loop)
         write(31,"(1x,e15.5)") 0.0
      end do


      close(31)





      return
      end subroutine
